/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

public class Float {
    static final Float ERROR = new Float(-93242L);
    static final int ITNUM = 5;
    static final Float SQRT3 = new Float(1732050807568877294L, -18L);
    public static final Float PI = new Float(3141592653589793238L, -18L);
    public static final Float ZERO = new Float();
    public static final Float ONE = new Float(1L);
    public static final Float PIdiv2 = PI.Div(2L);
    public static final Float PIdiv4 = PIdiv2.Div(2L);
    public static final Float PIdiv6 = PIdiv2.Div(3L);
    public static final Float PIdiv12 = PIdiv6.Div(2L);
    public static final Float PImul2 = PI.Mul(2L);
    public static final Float PImul4 = PI.Mul(4L);
    public long m_Val;
    public long m_E;

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float(long value) {
        this.m_Val = value;
        this.m_E = 0L;
    }

    public Float(long value, long e) {
        this.m_Val = value;
        this.m_E = this.m_Val == 0L ? 0L : e;
    }

    public Float(Float value) {
        this.m_Val = value.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : value.m_E;
    }

    public long toLong() {
        long tmpE = this.m_E;
        long tmpVal = this.m_Val;
        while (tmpE != 0L) {
            if (tmpE < 0L) {
                tmpVal /= 10L;
                ++tmpE;
                continue;
            }
            tmpVal *= 10L;
            --tmpE;
        }
        return (int)tmpVal;
    }

    public String toShortString() {
        Long l = new Long(this.m_Val);
        String str = l.toString();
        int len = str.length() + (int)this.m_E;
        if (this.m_Val < 0L ? len > 1 : len > 0) {
            return str.substring(0, len);
        }
        return "0";
    }

    public String toString() {
        if (this.Equal(ERROR)) {
            return "NaN";
        }
        Long l = new Long(this.m_Val);
        String str = l.toString();
        int len = str.length();
        boolean neg = false;
        if (this.m_Val < 0L) {
            neg = true;
            str = str.substring(1, len);
            --len;
        }
        if (this.m_E < 0L) {
            int absE = (int)Math.abs(this.m_E);
            if (absE < len) {
                str = String.valueOf(str.substring(0, len - absE)) + "." + str.substring(len - absE);
            } else {
                int i = 0;
                while (i < absE - len) {
                    str = "0" + str;
                    ++i;
                }
                str = "0." + str;
            }
            if (neg) {
                str = "-" + str;
            }
        } else {
            int i = 0;
            while ((long)i < this.m_E) {
                str = String.valueOf(str) + "0";
                ++i;
            }
            if (neg) {
                str = "-" + str;
            }
        }
        return str;
    }

    public Float Add(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        long v2 = value.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 92233720368547758L) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 92233720368547758L) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1 || v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            v1 /= 10L;
            ++e1;
            v2 /= 10L;
            ++e2;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1) {
            return new Float(ERROR);
        }
        if (v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            return new Float(ERROR);
        }
        return new Float(v1 + v2, e1);
    }

    public Float Sub(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-value.m_Val, value.m_E));
    }

    public Float Mul(long value) {
        return this.Mul(new Float(value, 0L));
    }

    public Float Mul(Float value) {
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        if (value.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        while (true) {
            if (Math.abs(value.m_Val) > Math.abs(this.m_Val)) {
                if (Long.MAX_VALUE / Math.abs(this.m_Val) >= Math.abs(value.m_Val)) break;
                value.m_Val /= 10L;
                ++value.m_E;
                continue;
            }
            if (Long.MAX_VALUE / Math.abs(value.m_Val) >= Math.abs(this.m_Val)) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        long e = this.m_E + value.m_E;
        long v = this.m_Val * value.m_Val;
        return new Float(v, e);
    }

    public Float Div(long value) {
        return this.Div(new Float(value, 0L));
    }

    public Float Div(Float value) {
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        if (v1 == 0L) {
            return new Float(ZERO);
        }
        long v2 = value.m_Val;
        if (v2 == 0L) {
            return new Float(ERROR);
        }
        long val = 0L;
        while ((v1 %= v2) != 0L && Math.abs(val += v1 / v2) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(v1) > 0xCCCCCCCCCCCCCCCL) {
                v2 /= 10L;
                ++e2;
            } else {
                v1 *= 10L;
                --e1;
            }
            val *= 10L;
        }
        Float f = new Float(val, e1 - e2);
        f.RemoveZero();
        return f;
    }

    /*
     * Unable to fully structure code
     */
    public void RemoveZero() {
        if (this.m_Val != 0L) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.m_Val /= 10L;
            ++this.m_E;
lbl5:
            // 2 sources

            ** while (this.m_Val % 10L == 0L)
        }
lbl6:
        // 1 sources

    }

    public boolean Great(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 92233720368547758L) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 92233720368547758L) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 > v2;
    }

    public boolean Less(long x) {
        return this.Less(new Float(x, 0L));
    }

    public boolean Less(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 92233720368547758L) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 92233720368547758L) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 < v2;
    }

    public boolean Equal(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 92233720368547758L) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 92233720368547758L) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 == v2;
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    public static Float sin(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x.Mul(x));
        Float q1 = m1.Div(6L);
        Float m2 = x.Mul(x.Mul(m1));
        Float q2 = m2.Div(120L);
        Float m3 = x.Mul(x.Mul(m2));
        Float q3 = m3.Div(5040L);
        Float m4 = x.Mul(x.Mul(m3));
        Float q4 = m4.Div(362880L);
        Float result = x.Sub(q1).Add(q2).Sub(q3).Add(q4);
        if (result.Less(ONE.Neg())) {
            return new Float(-1L);
        }
        if (result.Great(ONE)) {
            return new Float(1L);
        }
        return result;
    }

    public static Float cos(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x);
        Float q1 = m1.Div(2L);
        Float m2 = m1.Mul(m1);
        Float q2 = m2.Div(24L);
        Float m3 = m1.Mul(m2);
        Float q3 = m3.Div(720L);
        Float m4 = m2.Mul(m2);
        Float q4 = m4.Div(40320L);
        Float result = ONE.Sub(q1).Add(q2).Sub(q3).Add(q4);
        if (result.Less(-1L)) {
            return new Float(-1L);
        }
        if (result.Great(ONE)) {
            return new Float(1L);
        }
        return result;
    }

    public static Float sqrt(Float x) {
        int sp = 0;
        boolean inv = false;
        if (x.Less(ZERO) || x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Equal(ONE)) {
            return new Float(ONE);
        }
        if (x.Less(ONE)) {
            x = ONE.Div(x);
            inv = true;
        }
        while (x.Great(new Float(16L))) {
            ++sp;
            x = x.Div(16L);
        }
        Float a = new Float(2L);
        int i = 5;
        while (i > 0) {
            Float b = x.Div(a);
            a = a.Add(b);
            a = a.Mul(new Float(5L, -1L));
            --i;
        }
        while (sp > 0) {
            --sp;
            a = a.Mul(4L);
        }
        if (inv) {
            a = ONE.Div(a);
        }
        return a;
    }

    public static Float tan(Float x) {
        Float c = Float.cos(x);
        if (c.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.sin(x).Div(c);
    }

    public static Float acos(Float x) {
        return PIdiv2.Sub(Float.asin(x));
    }

    public static Float asin(Float x) {
        if (x.Less(ONE.Neg()) || x.Great(ONE)) {
            return new Float(ERROR);
        }
        if (x.Equal(ONE.Neg())) {
            return PIdiv2.Neg();
        }
        if (x.Equal(ONE)) {
            return PIdiv2;
        }
        return Float.atan(x.Div(Float.sqrt(ONE.Sub(x.Mul(x)))));
    }

    public static Float atan(Float x) {
        Float a;
        boolean signChange = false;
        boolean Invert = false;
        int sp = 0;
        if (x.Less(ZERO)) {
            x = x.Neg();
            signChange = true;
        }
        if (x.Great(ONE)) {
            x = ONE.Div(x);
            Invert = true;
        }
        while (x.Great(PIdiv12)) {
            ++sp;
            a = x.Add(SQRT3);
            a = ONE.Div(a);
            x = x.Mul(SQRT3);
            x = x.Sub(ONE);
            x = x.Mul(a);
        }
        Float x2 = x.Mul(x);
        a = x2.Add(new Float(14087812L, -7L));
        a = new Float(55913709L, -8L).Div(a);
        a = a.Add(new Float(60310579L, -8L));
        a = a.Sub(x2.Mul(new Float(5160454L, -8L)));
        a = a.Mul(x);
        while (sp > 0) {
            a = a.Add(PIdiv6);
            --sp;
        }
        if (Invert) {
            a = PIdiv2.Sub(a);
        }
        if (signChange) {
            a = a.Neg();
        }
        return a;
    }

    public static Float atan2(Float x, Float y) {
        if (y.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.atan(x.Div(y));
    }
}

