/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

import com.lunagames.atc.AtcGame;
import com.lunagames.atc.PhysicsObject;

public class Airplane
extends PhysicsObject {
    private boolean m_collision;
    public static final int STATE_FLIGHT = 0;
    public static final int STATE_TAXIIN = 1;
    public static final int STATE_TAXIOUT = 2;
    public static final int STATE_EXIT = 3;
    public static final int STATE_LANDING = 4;
    public static final int STATE_TAKEOFF = 5;
    public static final int STATE_TAKEOFF_DONE = 6;
    public static final int DEST_EXIT1 = 16;
    public static final int DEST_EXIT2 = 17;
    public static final int DEST_EXIT3 = 18;
    public static final int DEST_EXIT4 = 19;
    public static final int DEST_LAND = 20;
    static final int FLIGHT_ALT = 10;
    static final int LANDING_SPEED = 600;
    static final int TAXI_SPEED = 350;
    static final int DECENT_TM = 7000;
    static final int CLIMB_TM = 3000;
    static final int TAKEOFF_TM = 6000;
    static final int WAIT_TAKEOFF_TM = 5000;
    private long m_timeInState;
    private long m_stateTm;
    private int m_state;
    private int m_destination;
    private boolean m_active;
    private int m_altitude;

    public void reset() {
        super.reset();
        this.m_collision = false;
        this.m_destination = 0;
        this.m_active = true;
        this.m_altitude = 10;
        this.setState(0);
    }

    public void startLanding() {
        this.setState(4);
        this.setSpeed(600 * AtcGame.getSpeedMultiplier());
    }

    public void startTaxiout() {
        this.m_altitude = 1;
        this.setSpeed(0);
        this.setState(2);
    }

    public void startTakeoff() {
        this.m_altitude = 1;
        this.setSpeed(0);
        this.setState(5);
    }

    public void startExit() {
        this.setState(3);
    }

    public void startFlight() {
        this.setState(0);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean active) {
        this.m_active = active;
    }

    private void setState(int state) {
        this.m_state = state;
        this.m_timeInState = System.currentTimeMillis();
        this.m_stateTm = 0L;
    }

    public int getState() {
        return this.m_state;
    }

    public long getTimeInState() {
        return System.currentTimeMillis() - this.m_timeInState;
    }

    public int getDestination() {
        return this.m_destination;
    }

    public void setDestination(int dest) {
        this.m_destination = dest;
    }

    public int getAltitude() {
        return this.m_altitude;
    }

    public void calcPhysics() {
        super.calcPhysics();
        if (this.m_state == 4 && this.m_stateTm < System.currentTimeMillis()) {
            this.m_stateTm = System.currentTimeMillis() + 7000L;
            --this.m_altitude;
            if (this.m_altitude == 1) {
                this.setState(1);
                this.setSpeed(350 * AtcGame.getSpeedMultiplier());
            }
        }
        if (this.m_state == 2 && this.getTimeInState() > 5000L) {
            this.startTakeoff();
        }
        if (this.m_state == 5) {
            this.setSpeed(300 * AtcGame.getSpeedMultiplier());
            if (this.getTimeInState() > 15000L) {
                this.setSpeed(600 * AtcGame.getSpeedMultiplier());
            }
            if (this.getTimeInState() > 20000L) {
                this.setSpeed(800 * AtcGame.getSpeedMultiplier());
                if (this.m_stateTm < System.currentTimeMillis()) {
                    this.m_stateTm = System.currentTimeMillis() + 3000L;
                    ++this.m_altitude;
                    if (this.m_altitude == 10) {
                        this.setState(6);
                    }
                }
            }
        }
    }

    public void setWarning(boolean b) {
        this.m_collision = b;
    }

    public boolean isWarning() {
        return this.m_collision;
    }
}

